#include <iostream>
#include <vector>
#include <set>
#include <algorithm>
#include <iterator>

using namespace std;

typedef long long ll;

int n, k, x;
vector<ll> p;
vector<ll> s;
multiset<ll> low, high;
ll sum_low = 0;
int k_low;

void add(ll val) {
    if (k_low == 0) {
        high.insert(val);
        return;
    }
    if (low.empty()) {
        low.insert(val);
        sum_low += val;
    } else {
        if (val <= *low.rbegin()) {
            low.insert(val);
            sum_low += val;
        } else {
            high.insert(val);
        }
    }

    if ((int)low.size() > k_low) {
        ll v = *low.rbegin();
        low.erase(prev(low.end()));
        sum_low -= v;
        high.insert(v);
    }
    if ((int)low.size() < k_low && !high.empty()) {
        ll v = *high.begin();
        high.erase(high.begin());
        low.insert(v);
        sum_low += v;
    }
}

void remove(ll val) {
    if (k_low == 0) {
        if (high.find(val) != high.end()) {
            high.erase(high.find(val));
        }
        return;
    }

    if (high.find(val) != high.end()) {
        high.erase(high.find(val));
    } else {
        auto it = low.find(val);
        if (it != low.end()) {
            low.erase(it);
            sum_low -= val;
        }
    }
    
    if ((int)low.size() < k_low && !high.empty()) {
        ll v = *high.begin();
        high.erase(high.begin());
        low.insert(v);
        sum_low += v;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    if (!(cin >> n >> k >> x)) return 0;

    p.resize(n + 1);
    s.resize(n + 1, 0);

    for (int i = 1; i <= n; i++) {
        cin >> p[i];
        s[i] = s[i-1] + p[i];
    }

    k_low = x - 1;

    for (int i = 1; i <= k; i++) {
        add(s[i]);
    }

    cout << (ll)x * s[k] - s[0] - sum_low;

    for (int i = 2; i <= n - k + 1; i++) {
        int r = i + k - 1;
        
        remove(s[i - 1]);
        add(s[r]);
        
        cout << " " << (ll)x * s[r] - s[i - 1] - sum_low;
    }
    
    cout << "\n";

    return 0;
}